{ $HDR$}
{**********************************************************************}
{ Unit archived using Team Coherence                                   }
{ Team Coherence is Copyright 2002 by Quality Software Components      }
{                                                                      }
{ For further information / comments, visit our WEB site at            }
{ http://www.TeamCoherence.com                                         }
{**********************************************************************}
{}
{ $Log:  11675: IdMessageCoderUUE.pas
{
    Rev 1.4    10/17/2003 12:41:16 AM  DSiders
  Added localization comments.
}
{
{   Rev 1.3    26/09/2003 01:06:18  CCostelloe
{ CodingType property added so caller can find out if it was UUE or XXE encoded
}
{
{   Rev 1.2    6/14/2003 03:07:20 PM  JPMugaas
{ Fixed MessageDecoder so that DecodeBegin is called right after creation and
{ DecodeEnd is called just before destruction.  I also fixed where the code was
{ always assuming that LDecode was always being created.
}
{
{   Rev 1.1    6/13/2003 07:58:44 AM  JPMugaas
{ Should now compile with new decoder design.
}
{
{   Rev 1.0    11/13/2002 07:57:14 AM  JPMugaas
}
unit IdMessageCoderUUE;

{
2003-Sep-20 Ciaran Costelloe
  CodingType property added so caller can find out if it was UUE or XXE encoded
}

interface

uses
  Classes,
  IdCoder3to4, IdMessageCoder, IdMessage;

type
  TIdMessageDecoderUUE = class(TIdMessageDecoder)
  protected
    FCodingType: string;
  public
    function ReadBody(ADestStream: TStream; var AMsgEnd: Boolean): TIdMessageDecoder; override;
    property CodingType: string read FCodingType;
  end;

  TIdMessageDecoderInfoUUE = class(TIdMessageDecoderInfo)
  public
    function CheckForStart(ASender: TIdMessage; ALine: string): TIdMessageDecoder; override;
  end;

  TIdMessageEncoderUUEBase = class(TIdMessageEncoder)
  protected
    FEncoderClass: TIdEncoder3to4Class;
  public
    procedure Encode(ASrc: TStream; ADest: TStream); override;
  end;

  TIdMessageEncoderUUE = class(TIdMessageEncoderUUEBase)
  public
    constructor Create(AOwner: TComponent); override;
  end;

  TIdMessageEncoderInfoUUE = class(TIdMessageEncoderInfo)
  public
    constructor Create; override;
  end;

implementation

uses
  IdCoderUUE, IdCoderXXE, IdCoreGlobal, IdException, IdGlobal, IdResourceStrings,
  SysUtils;

{ TIdMessageDecoderInfoUUE }

function TIdMessageDecoderInfoUUE.CheckForStart(ASender: TIdMessage;
 ALine: string): TIdMessageDecoder;
var
  LPermissionCode: integer;
begin
  LPermissionCode := StrToIntDef(Copy(ALine, 7, 3), 0);
  if AnsiSameText(Copy(ALine, 1, 6), 'begin ') and (Copy(ALine, 10, 1) = ' ') and (LPermissionCode > 0)    {Do not Localize}
   then begin
    Result := TIdMessageDecoderUUE.Create(ASender);
    with TIdMessageDecoderUUE(Result) do begin
      FFilename := Copy(ALine, 11, MaxInt);
      FPartType := mcptAttachment;
    end;
  end else begin
    Result := nil;
  end;
end;

{ TIdMessageDecoderUUE }

function TIdMessageDecoderUUE.ReadBody(ADestStream: TStream; var AMsgEnd: Boolean): TIdMessageDecoder;
var
  LDecoder: TIdDecoder4to3;
  LLine: string;
begin
  AMSgEnd := False;
  Result := nil;
  LLine := ReadLn;
  LDecoder := nil;
  if (Length(LLine) > 0) then
  begin
    case LLine[1] of
      #32..#85: begin    {Do not Localize}
        // line length may be from 2 (first char + newline) to 65,
        // this is 0 useable to 63 usable bytes, + #32 gives this as a range.
        // (yes, the line length is encoded in the first bytes of each line!)
        LDecoder := TIdDecoderUUE.Create(nil);
        LDecoder.DecodeBegin(ADestStream);
        FCodingType := 'UUE'; {do not localize}
      end;
      'h': begin  {do not localize}
        LDecoder := TIdDecoderXXE.Create(nil);
        LDecoder.DecodeBegin(ADestStream);
        FCodingType := 'XXE'; {do not localize}
      end;
      else begin
        raise EIdException.Create(RSUnrecognizedUUEEncodingScheme);
      end;
    end;
  end;
  try
    if Assigned(LDecoder) then
    begin
      repeat
        if (Length(Trim(LLine)) = 0) or (LLine = LDecoder.FillChar) then begin
          // UUE: Comes on the line before end. Supposed to be `, but some put a
          // blank line instead
        end else begin
          LDecoder.Decode(LLine);
        end;
        LLine := ReadLn;
      until AnsiSameText(Trim(LLine), 'end');    {Do not Localize}
      LDecoder.DecodeEnd;
    end;
  finally FreeAndNil(LDecoder); end;
end;

{ TIdMessageEncoderInfoUUE }

constructor TIdMessageEncoderInfoUUE.Create;
begin
  inherited;
  FMessageEncoderClass := TIdMessageEncoderUUE;
end;

{ TIdMessageEncoderUUEBase }

procedure TIdMessageEncoderUUEBase.Encode(ASrc, ADest: TStream);
var
  s: string;
  LEncoder: TIdEncoder3to4;
begin
  ASrc.Position := 0;
  s := 'begin ' + IntToStr(PermissionCode) + ' ' + Filename + EOL;    {Do not Localize}
  ADest.WriteBuffer(s[1], Length(s));
  LEncoder := FEncoderClass.Create(nil); try
    while ASrc.Position < ASrc.Size do begin
      s := LEncoder.Encode(ASrc, 45) + EOL;
      ADest.WriteBuffer(s[1], Length(s));
    end;
    s := LEncoder.FillChar + EOL + 'end' + EOL;    {Do not Localize}
    ADest.WriteBuffer(s[1], Length(s));
  finally FreeAndNil(LEncoder); end;
end;

{ TIdMessageEncoderUUE }

constructor TIdMessageEncoderUUE.Create(AOwner: TComponent);
begin
  inherited;
  FEncoderClass := TIdEncoderUUE;
end;

initialization
  TIdMessageDecoderList.RegisterDecoder('UUE', TIdMessageDecoderInfoUUE.Create);    {Do not Localize}
  TIdMessageEncoderList.RegisterEncoder('UUE', TIdMessageEncoderInfoUUE.Create);    {Do not Localize}
end.
